class OneOnOne extends Mutator config(AltUT);

var config string GameName;

function PreBeginPlay()
{
	Super.PreBeginPlay();

	SaveConfig();
	Level.Game.HUDType = Class'OneOnOne_HUD';
	Level.Game.ScoreBoardType = Class'OneOnOne_SB';
	Level.Game.GameName = GameName;

	AddMutator(Level.Spawn(class'OneOnOne_Stats'));
}

function bool AlwaysKeep(Actor Other) 
{	
	if (Other.IsA('PlayerPawn'))
        	{
		PlayerPawn(Other).PlayerReplicationInfoClass = class'myPRI';
		return true;
		}
	if (Other.IsA('Bot'))
        	{
		Bot(Other).PlayerReplicationInfoClass = class'myPRI';
		return true;
		}	
	if (NextMutator != None)
		return (NextMutator.AlwaysKeep(Other));	
	return false;
}

defaultproperties
{
GameName="1on1 Deathmatch"
}
